/*
 * Decompiled with CFR 0.152.
 */
package com.tianti;

import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class SyncHttp {
    private String _url = "";
    private String _redirect_url = "";
    private String _req_method;
    private String _error_last;
    private REQ_PROGRESS _progress_last;
    private int _response_code;
    private int _task_index;
    private final int _redirect_max = 5;
    private static int DEFAULT_POOL_SIZE = 512;
    private static int DEFAULT_TIME_OUT = 10000;
    ByteArrayOutputStream _response_body_bytes;
    ByteArrayOutputStream _req_data;
    public final String TAG = "SyncHttp";
    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private int _timeout;

    public SyncHttp(int n, int n2) {
        this._task_index = n;
        this._progress_last = REQ_PROGRESS._null;
        this._response_body_bytes = new ByteArrayOutputStream(DEFAULT_POOL_SIZE);
        this._req_data = null;
        this._timeout = n2 < 0 ? DEFAULT_TIME_OUT : n2;
    }

    public static void GET(int n, String string, int n2) {
        SyncHttp syncHttp = new SyncHttp(n, n2);
        syncHttp.start(string, "GET", null);
    }

    public static void POST(int n, String string, byte[] byArray, int n2) {
        SyncHttp syncHttp = new SyncHttp(n, n2);
        syncHttp.start(string, "POST", byArray);
    }

    public static native void finishedCallback(int var0, int var1, byte[] var2);

    public void start(String string, String string2, byte[] byArray) {
        this._url = string;
        this._req_method = string2;
        if (byArray != null && byArray.length > 0) {
            this._req_data = new ByteArrayOutputStream(byArray.length);
            try {
                this._req_data.write(byArray);
            }
            catch (IOException iOException) {
                this._req_data.reset();
            }
        }
        this.run();
        SyncHttp.finishedCallback(this._task_index, this._response_code, this.getResponseBody());
    }

    private void setErrorMsg(String string) {
        this._error_last = string;
    }

    private void setLastProgress(REQ_PROGRESS rEQ_PROGRESS) {
        this._progress_last = rEQ_PROGRESS;
    }

    private void writeResponseBody(byte[] byArray, int n) {
        this._response_body_bytes.write(byArray, 0, n);
    }

    public byte[] getResponseBody() {
        return this._response_body_bytes.toByteArray();
    }

    private String getMethod() {
        return this._req_method;
    }

    private byte[] getPostData() {
        return this._req_data != null ? this._req_data.toByteArray() : null;
    }

    public void dumpResponsese() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 512;
        Log.d((String)"SyncHttp", (String)("datalen=" + n2));
        for (n2 = this.getResponseBody().length; n2 > 0; n2 -= n) {
            n = n2 > n4 ? n4 : n2;
            String string = new String(this.getResponseBody(), n3, n);
            Log.d((String)"SyncHttp", (String)string);
            n3 += n4;
        }
    }

    private void run() {
        this._response_code = this.doRequest(this._url);
        int n = 5;
        while (!this._redirect_url.isEmpty() && --n >= 0) {
            String string = this._redirect_url;
            this._redirect_url = "";
            this._response_code = this.doRequest(string);
        }
    }

    protected String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRequest(String string) {
        this._progress_last = REQ_PROGRESS._null;
        this._response_body_bytes.reset();
        long l = System.currentTimeMillis();
        REQ_PROGRESS rEQ_PROGRESS = REQ_PROGRESS._null;
        String string2 = new String();
        int n = 0;
        HttpURLConnection httpURLConnection = null;
        try {
            int n2;
            Object object;
            Object object2;
            String string3 = this.getMethod();
            rEQ_PROGRESS = REQ_PROGRESS._parse;
            URL uRL = new URL(string);
            rEQ_PROGRESS = REQ_PROGRESS._open;
            if (uRL.getProtocol().equals("http")) {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            if (uRL.getProtocol().equals("https")) {
                httpURLConnection = (HttpsURLConnection)uRL.openConnection();
            }
            rEQ_PROGRESS = REQ_PROGRESS._set;
            httpURLConnection.setInstanceFollowRedirects(true);
            httpURLConnection.setConnectTimeout(this._timeout);
            httpURLConnection.setReadTimeout(this._timeout);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            if (string3.equals("POST")) {
                httpURLConnection.setDoOutput(true);
                object2 = this.getPostData();
                if (object2 != null && ((byte[])object2).length > 0) {
                    httpURLConnection.addRequestProperty("Content-Type", this.getBodyContentType());
                    object = new DataOutputStream(httpURLConnection.getOutputStream());
                    ((FilterOutputStream)object).write((byte[])object2);
                    ((FilterOutputStream)object).close();
                }
            }
            rEQ_PROGRESS = REQ_PROGRESS._request;
            n = httpURLConnection.getResponseCode();
            rEQ_PROGRESS = REQ_PROGRESS._read;
            try {
                object2 = httpURLConnection.getInputStream();
            }
            catch (IOException iOException) {
                object2 = httpURLConnection.getErrorStream();
            }
            object = new byte[512];
            int n3 = 0;
            while ((n2 = ((InputStream)object2).read((byte[])object)) != -1) {
                this.writeResponseBody((byte[])object, n2);
                n3 += n2;
            }
            if (n == 301 || n == 302 || n == 303) {
                this._redirect_url = httpURLConnection.getHeaderField("Location");
            }
            rEQ_PROGRESS = REQ_PROGRESS._finish;
        }
        catch (MalformedURLException malformedURLException) {
            string2 = malformedURLException.getMessage();
            Log.e((String)"SyncHttp", (String)malformedURLException.toString());
        }
        catch (IOException iOException) {
            string2 = iOException.getMessage();
            Log.e((String)"SyncHttp", (String)iOException.toString());
        }
        catch (Exception exception) {
            string2 = exception.toString();
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        this.setErrorMsg(string2);
        this.setLastProgress(rEQ_PROGRESS);
        long l2 = System.currentTimeMillis() - l;
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum REQ_PROGRESS {
        _null,
        _parse,
        _open,
        _set,
        _request,
        _read,
        _finish;

    }
}

