/*
 * Decompiled with CFR 0.152.
 */
package com.tianti.util;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.Locale;

public class DeviceInfo {
    private static Context mParamContext;

    public static void init(Context context) {
        mParamContext = context;
        DeviceInfo.deviceInit();
    }

    public static native void deviceInit();

    private static boolean checkPermission(String string) {
        PackageManager packageManager = mParamContext.getPackageManager();
        return packageManager.checkPermission(string, mParamContext.getPackageName()) == 0;
    }

    public static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    private static String getMac() {
        try {
            WifiManager wifiManager = (WifiManager)mParamContext.getSystemService("wifi");
            if (DeviceInfo.checkPermission("android.permission.ACCESS_WIFI_STATE")) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                return wifiInfo.getMacAddress();
            }
            Log.e((String)"DeviceInfo", (String)"Could not get mac address.[no permission android.permission.ACCESS_WIFI_STATE");
        }
        catch (Exception exception) {
            Log.e((String)"DeviceInfo", (String)("Could not get mac address." + exception.toString()));
        }
        return "";
    }

    public static String getDeviceID() {
        return Settings.Secure.getString((ContentResolver)mParamContext.getContentResolver(), (String)"android_id");
    }

    private static int getFieldInt(Object object, String string) {
        try {
            Field field = DisplayMetrics.class.getDeclaredField(string);
            field.setAccessible(true);
            return field.getInt(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static String getResolution() {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)mParamContext.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n = -1;
            int n2 = -1;
            if ((DeviceInfo.mParamContext.getApplicationInfo().flags & 0x2000) == 0) {
                n = DeviceInfo.getFieldInt(displayMetrics, "noncompatWidthPixels");
                n2 = DeviceInfo.getFieldInt(displayMetrics, "noncompatHeightPixels");
            }
            if (n == -1 || n2 == -1) {
                n = displayMetrics.widthPixels;
                n2 = displayMetrics.heightPixels;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n);
            stringBuffer.append("*");
            stringBuffer.append(n2);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            Log.e((String)"DeviceInfo", (String)"read resolution fail", (Throwable)exception);
            return "";
        }
    }

    public static String getProxyHostAndPort() {
        String string = System.getProperty("http.proxyHost");
        String string2 = System.getProperty("http.proxyPort");
        String string3 = new String("");
        if (string != null) {
            string3 = string3 + string;
        }
        if (string2 != null) {
            string3 = string3 + ":" + string2;
        }
        return string3;
    }

    public static String getNetwork() {
        try {
            PackageManager packageManager = mParamContext.getPackageManager();
            if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", mParamContext.getPackageName()) != 0) {
                return "";
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)mParamContext.getSystemService("connectivity");
            if (connectivityManager == null) {
                return "";
            }
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                if (networkInfo.getType() == 1) {
                    return "wifi";
                }
                if (networkInfo.getSubtypeName() != null) {
                    return networkInfo.getSubtypeName();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @TargetApi(value=21)
    public static long isNetworkConnected() {
        try {
            PackageManager packageManager = mParamContext.getPackageManager();
            if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", mParamContext.getPackageName()) != 0) {
                return 0L;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)mParamContext.getSystemService("connectivity");
            if (connectivityManager == null) {
                return 0L;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                Network[] networkArray;
                for (Network network : networkArray = connectivityManager.getAllNetworks()) {
                    NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                    if (!networkCapabilities.hasTransport(1) && !networkCapabilities.hasTransport(0) && !networkCapabilities.hasTransport(4) && !networkCapabilities.hasTransport(3)) continue;
                    return 1L;
                }
            } else {
                NetworkInfo[] networkInfoArray = connectivityManager.getAllNetworkInfo();
                if (networkInfoArray != null) {
                    for (int i = 0; i < networkInfoArray.length; ++i) {
                        if (networkInfoArray[i] == null || !networkInfoArray[i].isConnected()) continue;
                        return 1L;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public static String getVersionName() {
        PackageManager packageManager = mParamContext.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(mParamContext.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getChannel() {
        String string = "";
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = mParamContext.getPackageManager().getApplicationInfo(mParamContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        if (applicationInfo != null && applicationInfo.metaData != null && (string = applicationInfo.metaData.getString("TT_CHANNEL")) == null) {
            string = "";
        }
        return string;
    }

    public static String getAppID() {
        String string = "";
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = mParamContext.getPackageManager().getApplicationInfo(mParamContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        if (applicationInfo != null && applicationInfo.metaData != null && (string = applicationInfo.metaData.getString("TT_APPID")) == null) {
            string = "";
        }
        return string;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getAndroidVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getCarrier() {
        TelephonyManager telephonyManager = (TelephonyManager)mParamContext.getSystemService("phone");
        try {
            String string;
            if (DeviceInfo.checkPermission("android.permission.READ_PHONE_STATE") && (string = telephonyManager.getSimOperator()) != null) {
                return string;
            }
        }
        catch (Exception exception) {
            Log.e((String)"DeviceInfo", (String)"permission err", (Throwable)exception);
        }
        return "";
    }

    public static long getInstalTime() {
        long l = 0L;
        return l;
    }

    public static String getBrand() {
        return Build.BRAND;
    }

    public static String getFilesPath() {
        return mParamContext.getFilesDir().getAbsolutePath();
    }

    public static String getSDCardPath() {
        Object object;
        String string = new String("");
        boolean bl = false;
        boolean bl2 = false;
        if (DeviceInfo.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE")) {
            object = Environment.getExternalStorageState();
            if ("mounted".equals(object)) {
                bl2 = true;
                bl = true;
            } else if ("mounted_ro".equals(object)) {
                bl = true;
                bl2 = false;
            } else {
                bl2 = false;
                bl = false;
            }
        }
        if (bl) {
            object = Environment.getExternalStorageDirectory();
            if (object != null) {
                string = ((File)object).getAbsolutePath();
            }
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    private static byte[] createChecksum(String string) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        do {
            if ((n = ((InputStream)fileInputStream).read(byArray)) <= 0) continue;
            messageDigest.update(byArray, 0, n);
        } while (n != -1);
        ((InputStream)fileInputStream).close();
        return messageDigest.digest();
    }

    public static String fileMD5(String string) throws Exception {
        byte[] byArray = DeviceInfo.createChecksum(string);
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            string2 = string2 + Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1);
        }
        return string2;
    }
}

